unit wsc;

interface

const
   (* COMM Ports *)
   COM1 = 0;
   COM2 = 1;
   COM3 = 2;
   COM4 = 3;
   COM5 = 4;
   COM6 = 5;
   COM7 = 6;
   COM8 = 7;
   COM9 = 8;
   COM10 = 9;
   COM11 = 10;
   COM12 = 11;
   COM13 = 12;
   COM14 = 13;
   COM15 = 14;
   COM16 = 15;
   (* Baud Rate Codes *)
   Baud300  = 0;
   Baud600  = 1;
   Baud1200 = 2;
   Baud2400 = 3;
   Baud4800 = 4;
   Baud9600 = 5;
   Baud19200  = 6;
   Baud38400  = 7;
   Baud57600  = 8;
   Baud115200 = 9;
   (* Parity Codes *)
   NoParity    = 0;
   OddParity   = 1;
   EvenParity  = 2;
   MarkParity  = 3;
   SpaceParity = 4;
   (* Stop Bit Codes *)
   OneStopBit  = 0;
   TwoStopBits = 2;
   (* Word Length Codes *)
   WordLength5 = 5;
   WordLength6 = 6;
   WordLength7 = 7;
   WordLength8 = 8;
   (* WSC errors *)
   WSC_NO_DATA  = -100;
   WSC_RANGE    = -101;
   WSC_ABORTED  = -102;
   WSC_WIN32ERR = -103;
   WSC_EXPIRED  = -104;
   (* Windows comm errors *)
   IE_BADID      = -1;
   IE_OPEN       = -2;
   IE_NOPEN      = -3;
   IE_MEMORY     = -4;
   IE_DEFAULT    = -5;
   IE_HARDWARE   = -10;
   IE_BYTESIZE   = -11;
   IE_BAUDRATE   = -12;
   (* SioGetError masks *)
   WSC_RXOVER   = $0001;
   WSC_OVERRUN  = $0002;
   WSC_PARITY   = $0004;
   WSC_FRAME    = $0008;
   WSC_BREAK    = $0010;
   WSC_TXFULL   = $0100;

 function SioBaud(Port, BaudCode : Integer) : Integer; stdcall
 function SioCTS(Port : Integer) : Integer; stdcall
 function SioDCD(Port : Integer) : Integer; stdcall
 function SioDebug(Cmd : Integer) : Integer; stdcall
 function SioDone(Port : Integer) : Integer; stdcall
 function SioDSR(Port : Integer) : Integer; stdcall
 function SioDTR(Port : Integer; Cmd : Char) : Integer; stdcall
 function SioFlow(Port: Integer; Cmd : Char) : Integer; stdcall
 function SioGetc(Port: Integer) : Integer; stdcall
 function SioGets(Port: Integer; Buffer : PChar; Size : Word) : Integer; stdcall
 function SioInfo(Cmd : Char) : Integer; stdcall
 function SioParms(Port, ParityCode, StopBitsCode, DataBitsCode : Integer) : Integer; stdcall
 function SioPutc(Port : Integer; Ch : Char) : Integer; stdcall
 function SioPuts(Port : Integer; Buffer : PChar; Size : Word) : Integer; stdcall
 function SioRead(Port : Integer; Reg : Integer) : Integer; stdcall
 function SioReset(Port, RxQueSize, TxQueSize : Integer) : Integer; stdcall
 function SioRI(Port : Integer) : Integer; stdcall
 function SioRTS(Port : Integer; Cmd : Char ) : Integer; stdcall
 function SioRxClear(Port : Integer) : Integer; stdcall
 function SioRxQue(Port : Integer) : Integer; stdcall
 function SioStatus(Port : Integer; Mask : Word) : Integer; stdcall
 function SioTxClear(Port : Integer) : Integer; stdcall
 function SioTxQue(Port : Integer) : Integer; stdcall
 function SioWinError(Buffer : PChar; Size : Word) : Integer; stdcall

implementation

 function SioBaud; external 'WSC32.DLL';
 function SioCTS; external 'WSC32.DLL';
 function SioDCD; external 'WSC32.DLL';
 function SioDebug; external 'WSC32.DLL';
 function SioDone; external 'WSC32.DLL';
 function SioDSR; external 'WSC32.DLL';
 function SioDTR; external 'WSC32.DLL';
 function SioFlow; external 'WSC32.DLL';
 function SioGetc; external 'WSC32.DLL';
 function SioGets; external 'WSC32.DLL';
 function SioInfo; external 'WSC32.DLL';
 function SioParms; external 'WSC32.DLL';
 function SioPutc; external 'WSC32.DLL';
 function SioPuts; external 'WSC32.DLL';
 function SioRead; external 'WSC32.DLL';
 function SioReset ; external 'WSC32.DLL';
 function SioRI; external 'WSC32.DLL';
 function SioRTS; external 'WSC32.DLL';
 function SioRxClear; external 'WSC32.DLL';
 function SioRxQue; external 'WSC32.DLL';
 function SioStatus; external 'WSC32.DLL';
 function SioTxClear; external 'WSC32.DLL';
 function SioTxQue; external 'WSC32.DLL';
 function SioWinError; external 'WSC32.DLL';
end.
 